#!/bin/bash
# Generate ProfVault icons using ImageMagick
# Run: chmod +x generate_icons.sh && ./generate_icons.sh

# App color: Coral accent (#e86b5d)
for size in 16 32 48 128; do
  convert -size ${size}x${size} xc:'#e86b5d' \
    -gravity center \
    -pointsize $((size/2)) \
    -fill white \
    -font Helvetica-Bold \
    -annotate 0 'PV' \
    icon${size}.png
done

echo "Icons generated with coral color!"
