# ProfVault Form Filler - Chrome Extension

Auto-fill job application forms using your ProfVault profile data.

## Features

- **One-Click Form Filling**: Fill job applications on any website
- **Smart Field Matching**: Automatically matches form fields to your profile data
- **Secure Token Auth**: Connect securely with your ProfVault account
- **Floating Button**: Quick access on any page with forms
- **Visual Feedback**: See which fields were filled with a highlight effect

## Installation (Developer Mode)

1. Open Chrome and go to `chrome://extensions/`
2. Enable **Developer mode** (toggle in top right)
3. Click **Load unpacked**
4. Select the `chrome_extension` folder
5. The extension icon should appear in your toolbar

## Setup

1. Go to [ProfVault Profile Settings](https://myprofvault.com/profile/edit?section=api)
2. Generate an API token
3. Click the extension icon in Chrome
4. Paste your API token and click **Connect**

## Usage

1. Navigate to any job application form
2. Click the floating ProfVault button (bottom-right corner)
3. Or open the extension popup and click **Fill This Form**
4. Review the auto-filled fields and submit!

## How It Works

```
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│  Job App Form   │────▶│  Extension      │────▶│  ProfVault API  │
│  (Any Website)  │     │  Content Script │     │  /form_fields/  │
└─────────────────┘     └─────────────────┘     └─────────────────┘
        │                       │                       │
        │                       ▼                       │
        │               Detect form fields              │
        │               Extract names, labels           │
        │                       │                       │
        │                       └───────────────────────┘
        │                               │
        ▼                               ▼
   Fields filled                Match fields to
   with profile data            user profile data
```

## Supported Field Types

- Name (full, first, last)
- Email
- Phone
- Location/Address
- LinkedIn URL
- Portfolio/Website
- GitHub URL
- Professional Summary
- Work Experience
- Education
- Skills
- Languages

## File Structure

```
chrome_extension/
├── manifest.json         # Extension config (Manifest V3)
├── background/
│   └── background.js     # Service worker
├── content/
│   ├── content.js        # Form detection & filling
│   └── content.css       # Floating button styles
├── popup/
│   ├── popup.html        # Extension popup UI
│   ├── popup.css         # Popup styles
│   └── popup.js          # Popup logic
└── icons/                # Extension icons
```

## API Endpoints Used

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api/extension/auth/verify` | POST | Verify API token |
| `/api/extension/profile` | GET | Get user profile data |
| `/api/extension/form_fields/match` | POST | Match fields to profile |

## Development

### Building for Production

1. Update the `API_BASE_URL` in popup.js and background.js
2. Create a zip of the extension folder
3. Upload to Chrome Web Store Developer Dashboard

### Testing

1. Load the extension in Developer mode
2. Open any job application form
3. Check the console for debug logs
4. Use `chrome.storage.local.get(['profvault_token'], console.log)` to verify token storage

## Troubleshooting

**Extension not filling forms?**
- Check if you're logged in (token verified)
- Ensure the page has actual form inputs (not custom JS components)
- Check browser console for errors

**Token not saving?**
- Make sure you're pasting the complete token
- Check if the token is valid at ProfVault

**Fields not matching correctly?**
- Complete your ProfVault profile with all information
- Some custom form fields may not be recognized
